/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.transport.callback;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallback;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemInsertTransportCallback
implements TransportCallback {
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "item_insert");
    private static final Logger LOGGER = LogManager.getLogger(ItemInsertTransportCallback.class);
    private final BlockPos itemHandlerPosition;
    private final Direction incomingDirection;
    private final ItemStack toInsert;

    public ItemInsertTransportCallback(BlockPos itemHandlerPosition, Direction incomingDirection, ItemStack toInsert) {
        this.itemHandlerPosition = itemHandlerPosition;
        this.incomingDirection = incomingDirection;
        this.toInsert = toInsert;
    }

    @Nullable
    public static ItemInsertTransportCallback of(CompoundTag tag) {
        BlockPos itemHandlerPosition = BlockPos.m_122022_((long)tag.m_128454_("ihpos"));
        ItemStack toInsert = ItemStack.m_41712_((CompoundTag)tag.m_128469_("s"));
        Direction incomingDirection = DirectionUtil.safeGet((byte)tag.m_128451_("incdir"));
        if (toInsert.m_41619_()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemInsertTransportCallback(itemHandlerPosition, incomingDirection, toInsert);
    }

    @Override
    public void call(Network network, Level level, BlockPos currentPos, TransportCallback cancelCallback) {
        BlockEntity blockEntity = level.m_7702_(this.itemHandlerPosition);
        if (blockEntity == null) {
            LOGGER.warn("Destination item handler is gone at " + this.itemHandlerPosition);
            cancelCallback.call(network, level, currentPos, cancelCallback);
            return;
        }
        IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.incomingDirection.m_122424_()).orElse(null);
        if (itemHandler == null) {
            LOGGER.warn("Destination item handler is no longer exposing a capability at " + this.itemHandlerPosition);
            cancelCallback.call(network, level, currentPos, cancelCallback);
            return;
        }
        if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.toInsert, (boolean)true).m_41619_()) {
            ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.toInsert, (boolean)false);
        } else {
            cancelCallback.call(network, level, currentPos, cancelCallback);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128356_("ihpos", this.itemHandlerPosition.m_121878_());
        tag.m_128365_("s", (Tag)this.toInsert.m_41739_(new CompoundTag()));
        tag.m_128405_("incdir", this.incomingDirection.ordinal());
        return tag;
    }
}

